/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import org.firebirdsql.gds.GDSException;
import org.firebirdsql.gds.impl.GDSHelper;
import org.firebirdsql.jdbc.AbstractConnection;
import org.firebirdsql.jdbc.AbstractDatabaseMetaData;

public class FBDatabaseMetaData
extends AbstractDatabaseMetaData {
    public FBDatabaseMetaData(AbstractConnection c) throws GDSException {
        super(c);
    }

    public FBDatabaseMetaData(GDSHelper gdsHelper) {
        super(gdsHelper);
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        return RowIdLifetime.ROWID_UNSUPPORTED;
    }

    @Override
    public int getJDBCMajorVersion() {
        return 4;
    }

    @Override
    public int getJDBCMinorVersion() {
        try {
            String javaImplementation = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return System.getProperty("java.specification.version");
                }
            });
            if (javaImplementation != null && "1.7".compareTo(javaImplementation) <= 0) {
                return 1;
            }
            return 0;
        }
        catch (RuntimeException ex) {
            return 0;
        }
    }
}

