/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.sql.SQLException;
import java.sql.Savepoint;
import org.firebirdsql.jdbc.FirebirdSavepoint;

public class FBSavepoint
implements Savepoint,
FirebirdSavepoint {
    public static final String SAVEPOINT_ID_PREFIX = "svpt";
    private boolean valid = true;
    private int savepointId;
    private String name;
    private String serverId;

    public FBSavepoint(int id) {
        this.savepointId = id;
        this.serverId = this.getSavepointServerId(id);
    }

    public FBSavepoint(String name) {
        this.name = name;
        this.serverId = this.getSavepointServerId(name);
    }

    private String getSavepointServerId(int counter) {
        return SAVEPOINT_ID_PREFIX + counter;
    }

    private String getSavepointServerId(String name) {
        StringBuffer sb = new StringBuffer();
        sb.append('\"');
        char[] data = name.toCharArray();
        for (int i = 0; i < data.length; ++i) {
            if (data[i] == '\"') {
                sb.append('\"');
            }
            sb.append(data[i]);
        }
        sb.append('\"');
        return sb.toString();
    }

    String getServerSavepointId() {
        return this.serverId;
    }

    @Override
    public int getSavepointId() throws SQLException {
        if (this.name == null) {
            return this.savepointId;
        }
        throw new SQLException("Savepoint is named.");
    }

    @Override
    public String getSavepointName() throws SQLException {
        if (this.name == null) {
            throw new SQLException("Savepoint is unnamed.");
        }
        return this.name;
    }

    boolean isNamed() {
        return this.name == null;
    }

    boolean isValid() {
        return this.valid;
    }

    void invalidate() {
        this.valid = false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof FBSavepoint)) {
            return false;
        }
        FBSavepoint that = (FBSavepoint)obj;
        return this.name == null ? this.savepointId == that.savepointId : this.name.equals(that.name);
    }

    public int hashCode() {
        return this.name == null ? this.savepointId : this.name.hashCode();
    }
}

